#! /bin/bash

# 
# Copyright (c) 2019 Javier Peralta Saenz, Ariel Mora Jimenez.
# 
# This program is free software: you can redistribute it and/or modify  
# it under the terms of the GNU General Public License as published by  
# the Free Software Foundation, version 3.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#

CONT_USER=$USER
USER_ID=$UID
xhost +local:$CONT_USER
xhost +local:root

sudo docker run -it --rm \
    --name ros2 \
    --user=$USER_ID\
    --env="DISPLAY" \
    --workdir="/home/$CONT_USER" \
    --volume="/home/$CONT_USER:/home/$CONT_USER" \
    --volume="/etc/group:/etc/group:ro" \
    --volume="/etc/passwd:/etc/passwd:ro" \
    --volume="/etc/shadow:/etc/shadow:ro" \
    --volume="/etc/sudoers.d:/etc/sudoers.d:ro" \
    --volume="/tmp/.X11-unix:/tmp/.X11-unix:rw" \
    osrf/ros:dashing-desktop bash\

xhost -local:$CONT_USER
xhost -local:root
